    
  import javafx.application.Application;
  import javafx.event.ActionEvent;
  import javafx.scene.Scene;
  import javafx.scene.control.*;
  import javafx.scene.layout.StackPane;
  import javafx.scene.paint.Color;
  import javafx.stage.Stage;

  public class PopUpMenu extends Application 
  {
     Label aLabel;
     MenuItem red, green, blue, black, orange;
    
     @Override
     public void start(Stage primaryStage) 
     {
        // Create the pop-up menu
        ContextMenu popUpMenu = new ContextMenu();
        
        // Create the menu items and event handler
        red = new MenuItem("Red");
        green = new MenuItem("Green");
        blue = new MenuItem("Blue");
        black = new MenuItem("Black");
        orange = new MenuItem("Orange");
        red.setOnAction(e-> colorChangeHandler(e));
        green.setOnAction(e-> colorChangeHandler(e));
        blue.setOnAction(e-> colorChangeHandler(e));
        black.setOnAction(e-> colorChangeHandler(e));
        orange.setOnAction(e-> colorChangeHandler(e));
        SeparatorMenuItem separator1= new SeparatorMenuItem();

        // Add the menu items to the menu
        popUpMenu.getItems().addAll(red, green, blue, separator1, 
                                    black, orange);          

        // Create a component and associate it with the menu
        aLabel = new Label("Right click this text to change its color");
        aLabel.setTextFill(Color.BLUE);
        aLabel.setContextMenu(popUpMenu);

        StackPane root = new StackPane();
        root.getChildren().add(aLabel);
        
        Scene scene = new Scene(root, 300, 150);
        
        primaryStage.setTitle("Pop-Up Menu");
        primaryStage.setScene(scene);
        primaryStage.show();
     }
    
     public void colorChangeHandler(ActionEvent e)
     {
        if(e.getSource() == red)
        {  
           aLabel.setTextFill(Color.RED);
        }
        else if(e.getSource() == green)
 	       {
           aLabel.setTextFill(Color.GREEN);
        }
        else if(e.getSource() == blue)
        { 
           aLabel.setTextFill(Color.BLUE);
        }
        else if(e.getSource() == black)
        {
           aLabel.setTextFill(Color.BLACK);
        }
        else if(e.getSource() == orange)
        {
           aLabel.setTextFill(Color.ORANGE);
        }
    
     public static void main(String[] args) 
     {
        launch(args);
     }
  }

